/*
 * Decompiled with CFR 0.152.
 */
package org.iqtig.pruefprogramm.xml.protocol;

import java.util.ArrayList;
import java.util.List;
import org.iqtig.pruefprogramm.xml.protocol.Case;
import org.iqtig.pruefprogramm.xml.protocol.ValidationItem;
import org.iqtig.pruefprogramm.xml.protocol.ValidationProvider;

public class ProtocolInformation {
    private final String statusDocument;
    private final String guid;
    private final List<ValidationProvider> valProvs;
    private final List<Case> cases;

    public ProtocolInformation(String statusDocument, String guid, List<ValidationProvider> valProvs, List<Case> cases) {
        this.statusDocument = statusDocument;
        this.guid = guid;
        this.valProvs = valProvs;
        this.cases = cases;
    }

    public String[] getValIds(ValidationProvider valProv) {
        ArrayList<String> valIds = new ArrayList<String>();
        for (ValidationItem valitem : valProv.getValItems()) {
            if (valIds.contains(valitem.id)) continue;
            valIds.add(valitem.id);
        }
        return valIds.toArray(new String[0]);
    }

    public List<ValidationItem> getValItem(String valItemId, Case theCase) {
        ArrayList<ValidationItem> valItems = new ArrayList<ValidationItem>();
        for (ValidationItem valItem : theCase.getProtocol().getValItems()) {
            if (!valItem.id.equals(valItemId)) continue;
            valItems.add(valItem);
        }
        return valItems;
    }

    public List<ValidationProvider> getValProvs() {
        return this.valProvs;
    }

    public List<Case> getCases() {
        return this.cases;
    }

    public String getStatusDocument() {
        return this.statusDocument;
    }

    public String getGuid() {
        return this.guid;
    }
}

